﻿using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace JSS.Controllers
{
    [Route("api/[controller]")]
    public class AthletesController : Controller
    {
        // GET: api/values
        [HttpGet]
        public AthletesViewModel Get()
        {
            return new AthletesViewModel(new[] {
                new Athlete("Jan Frodeno", "Niemcy", "08:06:30"),
                new Athlete("Sebastian Kienle", "Niemcy", "08:10:02"),
                new Athlete("Patrick Lange", "Niemcy", "08:11:14"),
                new Athlete("Ben Hoffman", "USA", "08:13:00"),
                new Athlete("Andi Boecherer", "Niemcy", "08:13:25")
            });
        }
    }

    public class AthletesViewModel
    {
        public AthletesViewModel(IEnumerable<Athlete> items)
        {
            Items = items;
        }
        [JsonProperty(PropertyName = "data")]
        public IEnumerable<Athlete> Items { get; set; }
    }

    public class Athlete
    {
        public Athlete(string name, string country, string time)
        {
            Name = name;
            Country = country;
            Time = time;
        }
        public string Name { get; set; }
        public string Country { get; set; }
        public string Time { get; set; }
    }
}
